/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.ui;

import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SourceDirViewerFilter extends ViewerFilter {

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof IJavaModel) {
            return true;
        } else if (element instanceof IJavaProject) {
            return true;
        } else if (element instanceof JarPackageFragmentRoot) {
            return false;
        } else if (element instanceof PackageFragmentRoot) {
            return true;
        } else if (element instanceof PackageFragment) {
            PackageFragment elem = (PackageFragment) element;

            if (elem.isDefaultPackage()) {
                return false;
            }
            return true;

        }
        return false;
    }
}
